(function(exports) {
exports.show = function(sensorsId, count)
{
	//if (!$.isEmptyObject(sensorsId)) //comited issue: https://gitlab.k-org.net/firmware/pc_soft/HTML_gen/issues/48
	{
		let h3 = $(`<h3>`).text(l100n.localize_string("ext_Channels_header"))
		let commands = [{"name": l100n.localize_string("not selected"), "command": "0x0"}]
		sensorsId.forEach(function(id, i) {
			commands.push({"name": id, "command": id})
		});

		let sensors_table = $('<table>');
		let table_head = $('<tr>').addClass('table_header')
		table_head.append($('<td colspan="1">').text(l100n.localize_string("ext_Channel")))
	    table_head.append($('<td colspan="1">').text(l100n.localize_string("ext_Settings")))
		table_head.append($('<td colspan="1">').text(l100n.localize_string("AI Read Float")))
		sensors_table.append(table_head)

		for (let sensor_number = 1; sensor_number <= count; sensor_number++)
		{
			configuration.add_template({"index": `4C08_${sensor_number}`,"template": "combobox", "commands": commands})
			let tr = $('<tr class="can_hide">').append($('<td>').text(`${sensor_number}`))
			tr.append($('<td>').append($('<div class="sensor_select">').addClass("tag").attr({"index": `4C08:${sensor_number}`})))
			tr.append($('<td>').append($('<div>').addClass("tag").attr({"index": `4C31:${sensor_number}`})))
			sensors_table.append(tr)
		}

		//let sensors_div = $('<div>').addClass("board")		
		let sensors_head = $('<div>').text(l100n.localize_string("1 Wire accordion header")).addClass("accordion-header")
		let sensors_body = $('<div>').append(sensors_table).addClass("accordion-body")
		$("#boyan").append(h3).append(sensors_head).append(sensors_body)
		//$("#io_settings").append(sensors_div)

	}
	//console.log(configuration.data_type_template().templates)
}

exports.request_sensors_count = function()
{
	let query = '/get_od_data.form?';
	query += `0x4C0A_0`; //sensors count

	return fetch(query).then(response => response.text())
}

exports.request_sensors = function(start, count)
{
	let query = '/get_od_data.form?'
	for (let sensor_number = start; sensor_number < start + count; sensor_number++)
	{
		if (sensor_number > start) { query += "&"; }
		query += `0x4C0A_${sensor_number}`; //sensor ID
	}
	return fetch(query).then(response => response.text())
}

exports.request_sensors_all = async function(count, request_lenght)
{
	let one_wire_sensors_values = []
	for (let current_index = 1; current_index < count; current_index += request_lenght)
	{
		await one_wire.request_sensors(current_index, Math.min((count-current_index+1), request_lenght))
		.then(text => common.response_ready(text))
		.then(values => {
			one_wire_sensors_values = one_wire_sensors_values.concat(values)
		})
	}
	
	return one_wire_sensors_values
}
})(this.one_wire = {})
